LobbyState = inherited("LobbyState", State)

function LobbyState:new()
	local o = instance(self)
	return o
end

function LobbyState:host(port, maxPlayers)
	_config.port = port or _config.port
	_config.maxPlayers = maxPlayers or _config.maxPlayers
end

function LobbyState:connect(ip, port)
	_config.ip = ip or _config.ip
	_config.port = port or _config.port	
	
	self.lobby = GameLobby:newClient(APP.gameString, APP.versionString, _config.ip , _config.port)
end

function LobbyState:update(time)
	if self.lobby then
		self.lobby:update(time)	
	end
end

function LobbyState:keyPressed(key)
	if key == 13 then
		self.list:unregister()
		states.destroy("lobby")
		states.add(GameState:new(), "game")
	end
end

function LobbyState:init()
	
end

function LobbyState:render()
	--[[local x,y = 100, 20
	for index, game in ipairs(list) do
		video.renderTextSprites(game.description, x,y, 0, "medium", 255, 255,255,255)
		video.renderTextSprites("by "..game.creator, x,y+22, 0, "small", 255, 128,128,128)
		video.renderTextSprites(game.players.."/"..game.playersMax, x+200,y+22, 0, "small", 255, 128,192,128)
		video.renderTextSprites(game.map, x+300,y+22, 0, "small", 255, 255,255,128) 			
		video.renderTextSprites(algo.getSignificantTime(game.age)..algo.getSignificantTimeType(game.age).. " ago", x+420,y+22, 0, "small", 255, 255,128,255)
		y = y + 40
	end]]
end

function LobbyState:close()
	--self.list:unregister()
end